from fastapi import FastAPI, Query
from app.model_loader import load_model
from app.search_engine import SemanticSearch

app = FastAPI()
model = load_model()
search_engine = SemanticSearch(model, columns=['Cat_id', 'Cat_name'])  # <- Update columns here

@app.get("/search")
def search(query: str = Query(..., description="Your question/query")):
    results = search_engine.search(query)
    return {"query": query, "results": results}
